import { ListWithRemove, Button } from '@yandex-data-ui/common';
import React, { useCallback } from 'react';

import { CmsFormParams } from '../../../../state/fullProjectForm';
import { initialState } from '../../../../state/fullProjectForm/models';
import { CmsFormItem } from './CmsFormItem';
import classes from './CmsForm.module.css';

interface Props {
   value: typeof initialState.cmsSettings;
   readonly: boolean;

   onChange(v: typeof initialState.cmsSettings, params?: CmsFormParams, index?: number): void;
   onAdd(): void;
}

export const CmsForm: React.FC<Props> = React.memo(({ readonly, value, onChange, onAdd }) => {
   const onItemChange = useCallback(
      (v: typeof initialState.cmsSettings) => {
         return (params: CmsFormParams, index: number) => {
            onChange(v, params, index);
         };
      },
      [onChange],
   );

   return (
      <>
         <ListWithRemove
            list={{
               itemClassName: classes.listItem,
               itemsClassName: classes.list,
               items: value.map((e, i) => ({ ...e, id: i })),
               itemHeight: item => (item.params._type === 'custom' ? 300 : 160),
               virtualized: false,
               filterable: false,
               renderItem: function renderItem(item, isItemActive, index) {
                  return (
                     <CmsFormItem
                        readonly={readonly}
                        value={item.params}
                        index={index}
                        onChange={onItemChange(value)}
                        validation={item.validation}
                     />
                  );
               },
            }}
            onRemove={(removedItem, newList) => onChange(newList)}
            disableSingleItemRemove={true}
            iconSize={'s'}
            iconOnHover={true}
         />
         {readonly || (
            <Button size={'s'} type={'button'} view={'outlined'} onClick={onAdd} className={classes.button}>
               Add CMS
            </Button>
         )}
      </>
   );
});

CmsForm.displayName = 'CmsForm';
