import { boolean } from '@storybook/addon-knobs';
import { json } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { initialState } from '../../../../state/fullProjectForm';
import { reduxStoryDecorator } from '../../../../stories';
import { useFormParams } from '../../../../stories/reactHooks';
import { IStoryDefaults } from '../../../../stories/typings';

import { DeployingForm } from './DeployingForm';

function RegularStory() {
   const [{ params, validation }, updateParams] = useFormParams(initialState.deploying);

   return (
      <>
         <DeployingForm
            readonly={boolean('readonly', false)}
            value={params}
            validation={validation}
            onChange={updateParams}
         />

         <pre>{json(params)}</pre>
      </>
   );
}

export const Regular = () => <RegularStory />;

export default {
   decorators: [reduxStoryDecorator],
   title: 'project|sub_forms/DeployingForm',
} as IStoryDefaults;
