import { FormFieldType, FormLayout, IFormField } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { useCallback } from 'react';

import {
   deployConfigField,
   deployNetworkField,
   deployTagsField,
   deployConfigPolicyField,
} from '../../../../actions/host_actions/actions/commonFields';
import { DefaultDeployNetwork, DefaultProvisioner, IDeployConfig, Provisioner } from '../../../../models';
import { ProvisionerField, BooleanSwitcherField } from '../../../../rich_shared/form_fields';
import { DeployingFormParams } from '../../../../state/fullProjectForm';
import { FormProps } from '../../models';

export const deployingFields: IFormField<DeployingFormParams>[] = [
   {
      ...deployConfigField,
      getHelp: () => null,
   } as IFormField<any>,
   deployConfigPolicyField,
   {
      component: ProvisionerField,
      label: 'Provisioner',
      name: 'provisioner',
      type: FormFieldType.Custom,
   },
   deployNetworkField,
   deployTagsField,
   {
      label: 'Certificate deploy',
      name: 'certificate_deploy',
      type: FormFieldType.Custom,
      component: BooleanSwitcherField,
   },

   // hidden
   { name: 'deploy_config', type: FormFieldType.Hidden },
];

interface Props extends FormProps<DeployingFormParams> {
   readonly: boolean;
}

export const DeployingForm: React.FC<Props> = React.memo(({ readonly, value, onChange, validation }) => {
   const update = useCallback((_, v: DeployingFormParams) => onChange(updateDeployParams(v)), [onChange]);

   return (
      <FormLayout
         readonly={readonly}
         fields={deployingFields}
         value={value}
         validationResult={validation}
         onChange={update}
      />
   );
});

DeployingForm.displayName = 'DeployingForm';

export function updateDeployParams(v: DeployingFormParams): DeployingFormParams {
   const _deployConfig: IDeployConfig =
      v._deployConfig && v._deployConfig.config ? v._deployConfig : { config: '', provisioner: DefaultProvisioner };

   const result: DeployingFormParams = {
      _deployConfig,
      deploy_config_policy: v.deploy_config_policy,
      certificate_deploy: v.certificate_deploy,
      deploy_config: _deployConfig.config,
      provisioner: _deployConfig.provisioner,
   };

   if (result.provisioner === Provisioner.LUI) {
      result.deploy_network = v.deploy_network || DefaultDeployNetwork;
   }

   if (result.provisioner === Provisioner.EINE) {
      result.deploy_tags = v.deploy_tags;
   }

   return result;
}
