import { useIgnoreEvent } from '@yandex-infracloud-ui/libs';
import * as React from 'react';

import { DisabledChecksEditor } from '../../../../shared';

import { FormProps } from '../../models';

interface Props extends FormProps<Set<string>> {
   readonly: boolean;
   allAvailableProjectChecks: string[];
}

export const DisabledChecksForm: React.FC<Props> = React.memo(
   ({ readonly, value, onChange, allAvailableProjectChecks }) => (
      <DisabledChecksEditor
         disabled={readonly}
         value={value}
         allAvailableProjectChecks={allAvailableProjectChecks}
         onChange={useIgnoreEvent(onChange)}
      />
   ),
);

DisabledChecksForm.displayName = 'DisabledChecksForm';
