import * as React from 'react';
import {
   useCallback,
   // useEffect, useState
} from 'react';
import { AutomationLimit, IAutomationLimits } from '../../../../models';
import { useConstants } from '../../../../shared';
import { FormProps } from '../../models';

import { Automation } from '../ProjectAutomationLimits/Automation';
import classes from '../ProjectAutomationLimits/ProjectAutomationLimits.module.css';

interface Props extends FormProps<IAutomationLimits> {
   readonly: boolean;
}

export const HostLimits = React.memo(({ readonly, value, onChange }: Props) => {
   const { constants } = useConstants();

   const onLimitChange = useCallback(
      (name: string, v: AutomationLimit[]) => {
         onChange({
            ...value,
            [name]: v,
         });
      },
      [onChange, value],
   );

   return (
      <>
         {constants &&
            constants?.host_limits.map(limit => {
               return (
                  <Automation
                     className={classes.automation}
                     key={limit}
                     name={limit}
                     readonly={readonly}
                     value={value[limit] || []}
                     onChange={onLimitChange}
                  />
               );
            })}
      </>
   );
});

HostLimits.displayName = 'HostLimits';
