import { boolean } from '@storybook/addon-knobs';
import { json } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { initialState } from '../../../../state/fullProjectForm';
import { useFormParams } from '../../../../stories/reactHooks';
import { IStoryDefaults } from '../../../../stories/typings';

import { NotificationsForm } from './NotificationsForm';

function RegularStory() {
   const [{ params, validation }, updateParams] = useFormParams(initialState.notifications);

   return (
      <>
         <NotificationsForm
            readonly={boolean('readonly', false)}
            value={params}
            validation={validation}
            onChange={updateParams}
         />

         <pre>{json(params)}</pre>
      </>
   );
}

export const Regular = () => <RegularStory />;

export default {
   title: 'project|sub_forms/NotificationsForm',
} as IStoryDefaults;
