import {
   FieldLayout,
   FormFieldType,
   FormLayout,
   IFieldProps,
   IFormField,
   useIgnoreEvent,
} from '@yandex-infracloud-ui/libs';
import * as React from 'react';

import { EmailNotifications } from '../../../../rich_shared';
import { FormProps } from '../../models';
import { NotificationRecipients } from '../../../../models';
import { NotificationsFormParams } from 'state/fullProjectForm';

function NotificationsField({ readonly, config, value, onChange }: IFieldProps<NotificationRecipients>) {
   return (
      <FieldLayout config={config}>
         <EmailNotifications readonly={readonly} value={value} onChange={onChange} />
      </FieldLayout>
   );
}

const fields: IFormField<NotificationsFormParams>[] = [
   {
      component: NotificationsField,
      label: 'Notifications',
      name: 'recipients',
      type: FormFieldType.Custom,
   },
];

interface Props extends FormProps<NotificationsFormParams> {
   readonly: boolean;
}

export const NotificationsForm: React.FC<Props> = React.memo(({ readonly, value, onChange, validation }) => {
   return (
      <FormLayout
         readonly={readonly}
         onChange={useIgnoreEvent(onChange)}
         fields={fields}
         value={value}
         validationResult={validation}
      />
   );
});

NotificationsForm.displayName = 'NotificationsForm';
