import { boolean } from '@storybook/addon-knobs';
import { json } from '@yandex-infracloud-ui/libs';
import React from 'react';
import { reduxStoryDecorator } from 'stories';

import { initialState } from '../../../../state/fullProjectForm';
import { useFormParams } from '../../../../stories/reactHooks';
import { IStoryDefaults } from '../../../../stories/typings';
import { OthersForm } from './OthersForm';

function RegularStory() {
   const [{ params, validation }, updateParams] = useFormParams(initialState.others);

   return (
      <>
         <OthersForm
            readonly={boolean('readonly', false)}
            value={params}
            validation={validation}
            onChange={updateParams}
            isNew={initialState.isNewProject}
         />

         <pre>{json(params)}</pre>
      </>
   );
}

export const Regular = () => <RegularStory />;

export default {
   decorators: [reduxStoryDecorator],
   title: 'project|sub_forms/OthersForm',
} as IStoryDefaults;
