import { FormFieldType, FormLayout, IFormField } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { useCallback } from 'react';

import { OthersFormParams } from '../../../../state/fullProjectForm';
import { FormProps } from '../../models';
import { BooleanSwitcherField, ConstantSelectField, IConstantSelectConfig } from 'rich_shared/form_fields';
import { useSelector } from 'react-redux';
import { RootState } from 'state/store';

export const othersFields: IFormField<OthersFormParams>[] = [
   {
      getHelp: () => 'This request will be processed by IDM, it may take some time',
      label: 'Reboot via ssh',
      name: 'reboot_via_ssh',
      type: FormFieldType.Custom,
      component: BooleanSwitcherField,
   },
   {
      component: ConstantSelectField,
      label: 'Tier',
      name: 'tier',
      subConfig: {
         defaultPlaceholder: 'Select Tier',
         extractor: c => c.existing_tiers,
      } as IConstantSelectConfig,
      type: FormFieldType.Custom,
      isHidden: (_, context) => context.isNew || !context.isAdmin,
   },
];

interface Props extends FormProps<OthersFormParams> {
   readonly: boolean;
   isNew: boolean | null;
}

export const OthersForm: React.FC<Props> = React.memo(({ readonly, value, onChange, validation, isNew }) => {
   const user = useSelector((s: RootState) => s.globals.user);
   const isAdmin = user ? user.isAdmin : false;

   const update = useCallback((_, v: OthersFormParams) => onChange(updateOthersParams(v)), [onChange]);

   return (
      <FormLayout
         readonly={readonly}
         fields={othersFields}
         value={value}
         validationResult={validation}
         onChange={update}
         context={{ isNew, isAdmin }}
      />
   );
});

OthersForm.displayName = 'OthersForm';

export function updateOthersParams(v: OthersFormParams): OthersFormParams {
   const result: OthersFormParams = {
      reboot_via_ssh: v.reboot_via_ssh,
      tier: v.tier,
   };

   return result;
}
