import { boolean } from '@storybook/addon-knobs';
import { json } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { initialState } from '../../../../state/fullProjectForm';
import { reduxStoryDecorator } from '../../../../stories';
import { useFormParams } from '../../../../stories/reactHooks';
import { IStoryDefaults } from '../../../../stories/typings';

import { PlotsForm } from './PlotsForm';

function RegularStory() {
   const [{ params, validation }, updateParams] = useFormParams(initialState.plots);

   return (
      <>
         <PlotsForm
            readonly={boolean('readonly', false)}
            value={params}
            validation={validation}
            onChange={updateParams}
            isShadow={false}
         />
         <pre>{json(params)}</pre>
      </>
   );
}

export const Regular = () => <RegularStory />;

export default {
   decorators: [reduxStoryDecorator],
   title: 'project|sub_forms/PlotsForm',
} as IStoryDefaults;
