import { FormFieldType, FormLayout, IFormField, useIgnoreEvent } from '@yandex-infracloud-ui/libs';
import * as React from 'react';

import { ConstantSelectField, profileConfigSubConfig, TagInputField } from '../../../../rich_shared/form_fields';
import { ProfilingFormParams } from '../../../../state/fullProjectForm';
import { FormProps } from '../../models';

export const profilingFields: IFormField<ProfilingFormParams>[] = [
   {
      component: ConstantSelectField,
      label: 'Profile config',
      name: 'profile',
      subConfig: profileConfigSubConfig,
      type: FormFieldType.Custom,
   },
   {
      component: TagInputField,
      isHidden: p => !Boolean(p.profile),
      label: 'Profile tags',
      name: 'profile_tags',
      type: FormFieldType.Custom,
   },
];

interface Props extends FormProps<ProfilingFormParams> {
   readonly: boolean;
}

export const ProfilingForm: React.FC<Props> = React.memo(({ readonly, value, onChange, validation }) => (
   <FormLayout
      readonly={readonly}
      fields={profilingFields}
      value={value}
      validationResult={validation}
      onChange={useIgnoreEvent(onChange)}
   />
));

ProfilingForm.displayName = 'ProfilingForm';
