import { action } from '@storybook/addon-actions';
import { boolean, object } from '@storybook/addon-knobs';
import * as React from 'react';

import { AutomationLimit } from '../../../../models';
import { fullWidthOutlineDecorator } from '../../../../stories';
import { IStoryDefaults } from '../../../../stories/typings';

import { Automation } from './Automation';

export const Simple = () => (
   <Automation
      name={'max_cpu_failures'}
      readonly={boolean('readonly', false)}
      value={object('value', [new AutomationLimit(10, '1d'), new AutomationLimit(20, '2d')])}
      onChange={action('onChange')}
   />
);

export const WithoutValue = () => (
   <Automation
      name={'max_cpu_failures'}
      readonly={boolean('readonly', false)}
      value={object('value', [])}
      onChange={action('onChange')}
   />
);

export default {
   decorators: [fullWidthOutlineDecorator],
   title: 'project|sub_forms/ProjectAutomationLimits/Automation',
} as IStoryDefaults;
