import * as React from 'react';
import { useCallback } from 'react';
import { AutomationLimit } from '../../../../models';

import { AutomationRow } from './AutomationRow';
import { EmptyAutomationRow } from './EmptyAutomationRow';

interface Props {
   className?: string;
   name: string;
   readonly: boolean;
   value: AutomationLimit[];

   onChange(name: string, v: AutomationLimit[]): void;
}

export const Automation = React.memo(({ className = '', value = [], onChange, name, readonly }: Props) => {
   //region handlers
   const addRow = useCallback(() => {
      const newValue = [...value];
      newValue.push(new AutomationLimit(10, '1d'));

      onChange(name, newValue);
   }, [name, onChange, value]);

   const deleteRow = useCallback(
      (i: number) => {
         const newValue = [...value];
         newValue.splice(i, 1);

         onChange(name, newValue);
      },
      [name, onChange, value],
   );

   const change = useCallback(
      (i: number, v: AutomationLimit) => {
         const newValue = [...value];
         newValue[i] = v;

         onChange(name, newValue);
      },
      [name, onChange, value],
   );
   //endregion

   //region render
   if (value.length === 0) {
      return <EmptyAutomationRow className={className} name={name} readonly={readonly} onAdd={addRow} />;
   }

   return (
      <>
         {value.map((v, i) => (
            <AutomationRow
               key={i}
               className={className}
               index={i}
               first={i === 0}
               name={name}
               readonly={readonly}
               value={v}
               onChange={change}
               onAdd={addRow}
               onDelete={deleteRow}
            />
         ))}
      </>
   );
   //endregion
});

Automation.displayName = 'Automation';
