import { action } from '@storybook/addon-actions';
import { object } from '@storybook/addon-knobs';
import * as React from 'react';

import { AutomationLimit } from '../../../../models';
import { outlineDecorator } from '../../../../stories';
import { IStoryDefaults } from '../../../../stories/typings';

import { CustomAutomationPopup } from './CustomAutomationPopup';

export const CustomLimitForm = () => (
   <CustomAutomationPopup
      hint={'Short description of limit'}
      value={object('value', new AutomationLimit(10, '1d'))}
      onSubmit={action('onSubmit')}
      onCancel={action('onCancel')}
   />
);

export default {
   decorators: [outlineDecorator],
   title: 'project|sub_forms/ProjectAutomationLimits/CustomAutomationPopup',
} as IStoryDefaults;
