import { classNames, EMPTY_VALUE } from '@yandex-infracloud-ui/libs';
import { Button, Icon } from 'lego-on-react';
import * as React from 'react';

import { formatAutomationLimitName } from './AutomationRow';

import classes from './AutomationRow.module.css';
import addSvg from './icons/add.svg';

interface Props {
   className: string;
   name: string;
   readonly: boolean;

   onAdd(): void;
}

export function EmptyAutomationRow({ className, name, readonly, onAdd }: Props) {
   return (
      <div className={classNames(classes.automationRow, classes.emptyRow, className)}>
         <div className={classes.name}>
            <span title={name}>{formatAutomationLimitName(name)}</span>
         </div>

         <div className={classes.buttons}>
            {readonly ? (
               EMPTY_VALUE
            ) : (
               <Button
                  theme={'link'}
                  size={'s'}
                  name={`${name}_add-button`}
                  text={'Add condition'}
                  onClick={onAdd}
                  icon={<Icon url={addSvg} />}
               />
            )}
         </div>
      </div>
   );
}
