import { boolean } from '@storybook/addon-knobs';
import { getValidResult, json } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { IAutomationLimits } from '../../../../models';
import { _convertAutomationLimits } from '../../../../services/api/project_api';
import { FormParams } from '../../../../state/fullProjectForm';
import { reduxStoryDecorator } from '../../../../stories';
import { useFormParams } from '../../../../stories/reactHooks';
import { IStoryDefaults } from '../../../../stories/typings';

import { ProjectAutomationLimits } from './ProjectAutomationLimits';

// noinspection DuplicatedCode
const initialState: FormParams<IAutomationLimits> = {
   params: _convertAutomationLimits({
      max_cpu_failures: [{ limit: 20, period: '2d' }],
      max_dead_hosts: [{ limit: 10, period: '1d' }],
      max_disk_failures: [{ limit: 30, period: '2d' }],
      max_dns_fixes: [{ limit: 5, period: '1d' }],
      max_fs_check_failures: [{ limit: 10, period: '1d' }],
      max_link_failures: [
         { limit: 10, period: '1d' },
         { limit: 20, period: '1d' },
      ],
      max_memory_failures: [{ limit: 10, period: '1d' }],
      max_reboots_failures: [{ limit: 10, period: '1s' }],
      max_ssdsd_failures: [
         { limit: 30, period: '1d' },
         { limit: 40, period: '1m' },
      ],
      max_ssh_failures: [{ limit: 20, period: '1d' }],
      max_tainted_kernel_failures: [{ limit: 10, period: '1d' }],
      max_unreachable_failures: [
         { limit: 1, period: '1d' },
         { limit: 1, period: '1d' },
      ],
      max_walle_always_crit_failures: [{ limit: 12, period: '12d' }],
      max_walle_mock_check_failures: [{ limit: 2, period: '2d' }],
      max_walle_redeploy_failures: [{ limit: 1, period: '1d' }],
   } as any),
   validation: getValidResult(),
};

const RegularStory = () => {
   const [{ params, validation }, updateParams] = useFormParams(initialState);

   return (
      <>
         <ProjectAutomationLimits
            readonly={boolean('readonly', false)}
            value={params}
            onChange={updateParams}
            validation={validation}
         />

         <pre>{json(params)}</pre>
      </>
   );
};

export const Regular = () => <RegularStory />;

export default {
   decorators: [reduxStoryDecorator],
   title: 'project|sub_forms/ProjectAutomationLimits',
} as IStoryDefaults;
