import * as React from 'react';
import { useCallback, useEffect, useState } from 'react';
import { AutomationLimit, IAutomationLimits } from '../../../../models';
import { useConstants } from '../../../../shared';
import { FormProps } from '../../models';

import { Automation } from './Automation';
import classes from './ProjectAutomationLimits.module.css';

interface LimitGroup {
   limits: string[];
   name: string;
}

interface Props extends FormProps<IAutomationLimits> {
   readonly: boolean;
}

// FIXME временно, до тех пор, пока не появится поддержка групп на беке
const secondGroupHardCoded = ['max_dead_hosts', 'max_dns_fixes'];

export const ProjectAutomationLimits = React.memo(({ readonly, value, onChange }: Props) => {
   const [groups, setGroups] = useState<LimitGroup[]>([]);

   const { constants } = useConstants();

   // Рассчет конфигурации групп после загрузки констант
   useEffect(() => {
      if (constants === null) {
         return;
      }

      const limits = constants.project_automation_limits;
      setGroups([
         {
            limits: limits.filter(l => !secondGroupHardCoded.includes(l)),
            name: 'Max allowed checks failures',
         },
         {
            limits: secondGroupHardCoded,
            name: 'Max allowed',
         },
      ]);
   }, [constants]);

   const onLimitChange = useCallback(
      (name: string, v: AutomationLimit[]) => {
         onChange({
            ...value,
            [name]: v,
         });
      },
      [onChange, value],
   );

   return (
      <>
         {groups.map(group => (
            <section key={group.name} className={classes.group}>
               <h3>{group.name}</h3>
               {group.limits.map(limit => (
                  <Automation
                     className={classes.automation}
                     key={limit}
                     name={limit}
                     readonly={readonly}
                     value={value[limit] || []}
                     onChange={onLimitChange}
                  />
               ))}
            </section>
         ))}
      </>
   );
});

ProjectAutomationLimits.displayName = 'ProjectAutomationLimits';
