import { useIgnoreEvent } from '@yandex-infracloud-ui/libs';
import * as React from 'react';

import { RestrictionEditor } from '../../../../shared';

import { FormProps } from '../../models';

interface Props extends FormProps<Set<string>> {
   readonly: boolean;
}

export const RestrictionsForm: React.FC<Props> = React.memo(({ readonly, value, onChange }) => (
   <RestrictionEditor disabled={readonly} value={value} onChange={useIgnoreEvent(onChange)} />
));

RestrictionsForm.displayName = 'RestrictionsForm';
