import { FormFieldType, FormLayout, IFormField, useIgnoreEvent } from '@yandex-infracloud-ui/libs';
import * as React from 'react';

import { NONE_ITEM, VlanSchema } from '../../../../models';
import {
   ConstantSelectField,
   HbfProjectField,
   IConstantSelectConfig,
   ipMethodSubConfig,
   VLANsSelectField2,
   VLANsSelectFieldConfig,
   BooleanSwitcherField,
} from '../../../../rich_shared/form_fields';
import { auth } from '../../../../services';
import { VlansFormParams } from '../../../../state/fullProjectForm';
import { FormProps } from '../../models';

const isMtn = (p: VlansFormParams) => p.vlan_scheme === NONE_ITEM || p.vlan_scheme === VlanSchema.MTN;

const isNotMtn = (p: VlansFormParams) => p.vlan_scheme === NONE_ITEM || p.vlan_scheme !== VlanSchema.MTN;

const fields: IFormField<VlansFormParams>[] = [
   {
      component: VLANsSelectField2,
      label: 'Owned VLANs',
      name: 'owned_vlans',
      type: FormFieldType.Custom,
      isDisabled: () => !auth.canEditOwnedVlans(),
   },
   {
      component: ConstantSelectField,
      label: 'VLAN schema',
      name: 'vlan_scheme',
      subConfig: {
         defaultPlaceholder: 'Select VLAN schema',
         extractor: c => c.vlan_schemes,
         withNone: true,
      } as IConstantSelectConfig,
      type: FormFieldType.Custom,
   },
   {
      component: HbfProjectField,
      isHidden: isNotMtn,
      label: 'MTN project ID',
      name: 'hbf_project_id',
      type: FormFieldType.Custom,
   },
   {
      label: 'Create fastbone DNS records',
      name: 'use_fastbone',
      type: FormFieldType.Custom,
      component: BooleanSwitcherField,
      isHidden: isNotMtn,
   },
   {
      component: ConstantSelectField,
      isHidden: isNotMtn,
      label: 'Host-id for IP-addresses',
      name: 'ip_method',
      subConfig: ipMethodSubConfig,
      type: FormFieldType.Custom,
   },
   {
      isHidden: isMtn,
      label: 'Native VLAN',
      name: 'native_vlan',
      type: FormFieldType.Number,
   },
   {
      component: VLANsSelectField2,
      isHidden: isMtn,
      label: 'Extra VLANs',
      name: 'extra_vlans',
      subConfig: { readonly: false } as VLANsSelectFieldConfig,
      type: FormFieldType.Custom,
   },
];

interface Props extends FormProps<VlansFormParams> {
   readonly: boolean;
}

export const VlansForm: React.FC<Props> = React.memo(({ readonly, value, onChange, validation }) => (
   <FormLayout
      readonly={readonly}
      fields={fields}
      value={value}
      validationResult={validation}
      onChange={useIgnoreEvent(onChange)}
   />
));

VlansForm.displayName = 'VlansForm';
