import React from 'react';
import { useSelector } from 'react-redux';
import { RouteComponentProps } from 'react-router';

import { OwnershipValue } from '../../../models';
import { HostListRich } from '../../../rich_shared/host_list';
import { useTitleForUnselectedProjects } from '../../../shared';
import { ownershipSelector } from '../../../state/projects';

export const HostListPage: React.FC<RouteComponentProps<{ id: string }>> = props => {
   const ownership = useSelector(ownershipSelector);

   useTitleForUnselectedProjects(ownership === OwnershipValue.My ? 'All my hosts' : 'All hosts');

   return <HostListRich useOwnershipFilter={true} {...props} />;
};

HostListPage.displayName = 'HostListPage';
