import { action } from '@storybook/addon-actions';
import { storiesOf } from '@storybook/react';
import * as React from 'react';

import { IProject } from '../../../../models';
import { userSwitcherDecorator, reduxStoryDecorator } from '../../../../stories';

import { AddHostsToProjectModal } from './AddHostsToProjectModal';

const project: IProject = {
   id: 'test_project',
   name: 'Test Project',
   use_fastbone: true,
};

storiesOf('projects|hosts', module)
   .addDecorator(userSwitcherDecorator)
   .addDecorator(reduxStoryDecorator)
   .add('AddHosts', () => <AddHostsToProjectModal ok={action('ok')} cancel={action('cancel')} id={project.id} />);
