import { WindowTitle } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { RouteComponentProps } from 'react-router';

import { AuditLog, ILogUrlParams } from '../../../rich_shared';

export const LogItemScreen = React.memo((props: RouteComponentProps<ILogUrlParams>) => (
   <>
      <WindowTitle value={'Audit log'} />

      <AuditLog id={props.match.params.id} layout={'single'} {...props} />
   </>
));

LogItemScreen.displayName = 'LogItemScreen';
