import { WindowTitle } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { RouteComponentProps } from 'react-router';

import { AuditLog, ILogUrlParams } from '../../../rich_shared';
import { useTitleForUnselectedProjects } from '../../../shared';

export const LogScreen = React.memo((props: RouteComponentProps<ILogUrlParams>) => {
   useTitleForUnselectedProjects('Audit log');

   return (
      <>
         <WindowTitle value={'Audit log'} />

         <AuditLog layout={'all'} {...props} />
      </>
   );
});

LogScreen.displayName = 'LogScreen';
