import { WindowTitle } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { useMemo } from 'react';
import { RouteComponentProps } from 'react-router';

import { ILogUrlParams, OperationLog } from '../../../rich_shared';

export const OperationLogItemScreen = React.memo((props: RouteComponentProps<ILogUrlParams>) => {
   const { id } = props.match.params;

   const forceFilters = useMemo(() => {
      const filters: any = {};
      if (id) {
         filters.id = id;
      }

      return filters;
   }, [id]);

   return (
      <>
         <WindowTitle value={'Operation log'} />
         <OperationLog layout={'single'} forceFilters={forceFilters} {...props} />
      </>
   );
});

OperationLogItemScreen.displayName = 'OperationLogItemScreen';
