import { WindowTitle } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { RouteComponentProps } from 'react-router';

import { ILogUrlParams, OperationLog } from '../../../rich_shared';
import { useTitleForUnselectedProjects } from '../../../shared';

export const OperationLogScreen = React.memo((props: RouteComponentProps<ILogUrlParams>) => {
   useTitleForUnselectedProjects('Operation log');

   return (
      <>
         <WindowTitle value={'Operation log'} />

         <OperationLog layout={'all'} {...props} />
      </>
   );
});

OperationLogScreen.displayName = 'OperationLogScreen';
