import { AppRoute, createRedirect } from '@yandex-infracloud-ui/libs';

import { ROUTE_LINKS } from '../../models';
import { HostListPage } from './hosts/HostListPage';
import { LogIndexScreen } from './log';
import { OperationLogIndexScreen } from './operation_log';

export const PROJECT_TABS: AppRoute[] = [
   { path: '/projects/hosts', exact: true, name: 'Hosts', component: HostListPage },
   { path: '/projects/log', name: 'Audit log', component: LogIndexScreen },
   { path: '/projects/operation_log', name: 'Operation log', component: OperationLogIndexScreen },
];

export const ROUTES: AppRoute[] = [
   ...PROJECT_TABS,
   {
      path: '/projects',
      exact: true,
      component: createRedirect(ROUTE_LINKS.home()),
   },
];
