import { AppRoute, createRedirect } from '@yandex-infracloud-ui/libs-next';

import { ROUTE_LINKS } from '../models';
import { ChecksIndexScreen } from './automation-plots';
import { ServicesIndexScreen } from './maintenance-plots';
import { HostScreenEnhanced } from './host';
import { About } from './other/About';
import { Error404Screen } from './other/Error404Screen';
import { JsException } from './other/js_exception';
import { OldRoutes } from './other/old_routes';
import { PreordersScreen } from './preorders';
import { ProjectPage } from './project/ProjectPage';
import { ProjectsIndexScreen } from './projects';
import { ScenarioOperationsIndexScreen } from './scenarios';

export const ROUTES: AppRoute[] = [
   { path: '/automation_plots', component: ChecksIndexScreen },
   { path: '/maintenance_plots', component: ServicesIndexScreen },
   { path: '/projects', component: ProjectsIndexScreen },
   { path: '/project/:id', component: ProjectPage },
   { path: '/host/:id', component: HostScreenEnhanced },
   { path: '/scenarios', component: ScenarioOperationsIndexScreen },
   { path: '/preorders', component: PreordersScreen },

   { path: '/old_routes', component: OldRoutes },
   { path: '/js_exception', component: JsException },
   { path: '/about', component: About },
   { path: '/', exact: true, component: createRedirect(ROUTE_LINKS.home()) },
   { component: Error404Screen },
];

export const YC_ROUTES: AppRoute[] = [
   { path: '/automation_plots', component: ChecksIndexScreen },
   { path: '/projects', component: ProjectsIndexScreen },
   { path: '/project/:id', component: ProjectPage },
   { path: '/host/:id', component: HostScreenEnhanced },

   { path: '/old_routes', component: OldRoutes },
   { path: '/js_exception', component: JsException },
   { path: '/about', component: About },
   { path: '/', exact: true, component: createRedirect(ROUTE_LINKS.home()) },
   { component: Error404Screen },
];
