import { Loader } from '@yandex-data-ui/common';
import { toasts } from '@yandex-infracloud-ui/libs';
import React from 'react';
import { RouteComponentProps } from 'react-router';
import { useConstants } from 'shared';
import { ScenarioList } from '../../../rich_shared';

export const ScenarioDefault = React.memo((props: RouteComponentProps) => {
   const { constants, isError } = useConstants();

   if (isError) {
      toasts.error('Сonstants are not available', 'Constant load API Error:');
   }

   if (constants === null && !isError) {
      return <Loader />;
   }

   return <ScenarioList {...props} constants={constants} />;
});

ScenarioDefault.displayName = 'ScenarioDefault';
