import { Observable, of } from 'rxjs';
import { fromPromise } from 'rxjs/internal-compatibility';
import { tap } from 'rxjs/operators';

export class ApiCache {
   private _currentRequests: Map<string, Promise<any>> = new Map();

   private _store: Map<string, any> = new Map();

   public request<T>(key: string, requester: () => Observable<T>, skipCache = false): Observable<T> {
      if (skipCache) {
         return requester();
      }

      if (this._store.has(key)) {
         return of<T>(this._store.get(key));
      }

      if (!this._currentRequests.has(key)) {
         const request = requester().pipe(
            tap((resp: T) => {
               this._store.set(key, resp);
               this._currentRequests.delete(key);
            }),
         );
         this._currentRequests.set(key, request.toPromise());
      }

      return fromPromise(this._currentRequests.get(key)!) as Observable<T>;
   }
}
