import { isEmpty } from '@yandex-infracloud-ui/libs';

import { IParsedQuery } from '../../models';

const HOSTS_SEPARATOR_REGEXP = /[\s,;+]+/;
const HOSTS_INV_REGEXP = /^\d+$/;
const HOSTS_TAG_REGEXP = /^#/;
const HOSTS_PATTERN_REGEXP = /\*+/;
const HOSTS_UUID_REGEXP = /\b([\da-f]{8}(-?[\da-f]{4}){3}-?[\da-f]{12})\b/i;

/**
 * Парсинг запроса, вычленение инвентарного номера, хостов, шаблонов, тегов
 *
 * Код портирован со старого UI (но сильно переделан в угоду читаемости)
 */
export function parseHostQuery(query: string): IParsedQuery {
   return query
      .trim()
      .split(HOSTS_SEPARATOR_REGEXP)
      .reduce(
         (acc, part) => {
            if (HOSTS_INV_REGEXP.test(part)) {
               acc.invs.push(parseInt(part, 10));
            } else if (HOSTS_TAG_REGEXP.test(part)) {
               if (part !== '#') {
                  acc.tags.push(part.replace(/^#/, ''));
               }
            } else if (HOSTS_PATTERN_REGEXP.test(part)) {
               acc.patterns.push(part);
            } else if (HOSTS_UUID_REGEXP.test(part)) {
               acc.uuids.push(part);
            } else if (!isEmpty(part)) {
               acc.names.push(part);
            }

            return acc;
         },
         {
            invs: [],
            names: [],
            patterns: [],
            tags: [],
            uuids: [],
         } as IParsedQuery,
      );
}

export function splitParams<T>(params: T, fields: (keyof T)[]): [Partial<T>, Partial<T>] {
   const firstParams: Partial<T> = {};
   const restParams: Partial<T> = {};

   Object.keys(params).forEach(field => {
      if (fields.includes(field as keyof T)) {
         firstParams[field] = params[field];
      } else {
         restParams[field] = params[field];
      }
   });

   return [firstParams, restParams];
}
