import { arrayToSet, HttpMethod, omitFields } from '@yandex-infracloud-ui/libs-next';
import { Observable } from 'rxjs';
import { map, tap } from 'rxjs/operators';

import { allAutomationPlotFields, IAutomationPlot, ICheck, IListResult, IPlotActionParams } from '../../models';
import { config } from '../config';

import { WalleBaseApi } from './base_api';

class AutomationPlotsApi extends WalleBaseApi {
   private _allFields = allAutomationPlotFields;

   public getList(): Observable<IListResult<IAutomationPlot>> {
      const params = {
         fields: this._allFields,
      };

      return this.request<typeof params, void, IListResult<IAutomationPlot>>(HttpMethod.GET, '', params).pipe(
         // Весь этот map просто преобразует owners из массива в Set
         map((resp: IListResult<IAutomationPlot>) => ({
            ...resp,
            result: resp.result.map(item => {
               item.owners = new Set(item.owners);

               return item;
            }),
         })),
      );
   }

   public getById(id: string): Observable<IAutomationPlot> {
      const params = {
         fields: this._allFields,
      };

      return this.request<typeof params, void, IAutomationPlot>(HttpMethod.GET, id, params).pipe(
         tap(plot => (plot.owners = arrayToSet(plot.owners as any))),
      );
   }

   public create(plot: IAutomationPlot): Observable<IAutomationPlot> {
      return this.request(HttpMethod.POST, '', null, plot);
   }

   public update(plot: IAutomationPlot): Observable<IAutomationPlot> {
      // Какой-то ужас в API
      const body = omitFields(plot, 'id');
      if (body.checks) {
         body.checks = body.checks.map(ch => omitFields(ch, 'start_time') as ICheck);
      }

      return this.request(HttpMethod.POST, plot.id, null, body);
   }

   public remove(id: string, params: IPlotActionParams): Observable<void> {
      return this.request(HttpMethod.DELETE, id, null, params);
   }

   public enableCheck(id: string, check: string, reason: string) {
      return this.request(HttpMethod.POST, `${id}/${check}/enable`, null, { reason });
   }

   public disableCheck(id: string, check: string, reason: string) {
      return this.request(HttpMethod.POST, `${id}/${check}/disable`, null, { reason });
   }
}

export const automationPlotsApi = new AutomationPlotsApi(`${config.walleApi}/v1/automation-plot/`);
