import { BaseApi, IApiError } from '@yandex-infracloud-ui/libs';
import { globalState } from '../../models';
import { sentry } from '../sentry';

export abstract class WalleBaseApi extends BaseApi {
   protected getCSRF(): string {
      return globalState.csrfToken.value;
   }

   protected handleError(resp: Response, error: IApiError): void {
      if (resp.status === 401) {
         globalState.user.next(null);
      }

      sentry.sendApiError(resp, error);
   }
}
