import { HttpMethod } from '@yandex-infracloud-ui/libs-next';
import { Observable } from 'rxjs';
import { map } from 'rxjs/operators';

import { IHostHealthRecord, IListResult } from '../../models';
import { config } from '../config';

import { WalleBaseApi } from './base_api';

class HealthApi extends WalleBaseApi {
   public getHostHealthDetails(fqdn: string): Observable<IListResult<IHostHealthRecord>> {
      return this.request<{ fqdn: string }, void, IListResult<IHostHealthRecord>>(HttpMethod.GET, '', { fqdn }).pipe(
         // Небольшой хак, чтобы total вынести вперед (удобнее)
         map(resp => ({ total: resp.total, ...resp })),
      );
   }
}

export const healthApi = new HealthApi(`${config.walleApi}/v1/health-checks`);
