import { HttpMethod } from '@yandex-infracloud-ui/libs-next';
import { Observable } from 'rxjs';

import { allPreorderFields, IAddPreorderParams, IListResult, IPreorder, IPreorderBaseParams } from '../../models';
import { config } from '../config';
import { splitParams } from './api_helpers';

import { WalleBaseApi } from './base_api';

class PreorderApi extends WalleBaseApi {
   private _allFields = allPreorderFields;

   public getList(): Observable<IListResult<IPreorder>> {
      const params = {
         fields: this._allFields,
      };

      return this.request(HttpMethod.GET, '', params);
   }

   public getById(id: number): Observable<IPreorder> {
      const params = {
         fields: this._allFields,
      };

      return this.request(HttpMethod.GET, `${id}`, params);
   }

   public restart(id: number, params: IPreorderBaseParams): Observable<void> {
      const [getParams, bodyParams] = splitParams(params, ['sudo']);

      return this.request(HttpMethod.POST, `${id}/restart`, getParams, bodyParams);
   }

   public addPreorder(params: Partial<IAddPreorderParams>): Observable<void> {
      const [getParams, bodyParams] = splitParams(params, ['sudo']);

      return this.request(HttpMethod.POST, '', getParams, bodyParams);
   }
}

export const preorderApi = new PreorderApi(`${config.walleApi}/v1/preorders`);
