import { AutomationLimit, IAutomationLimits } from '../../models';
import { _cleanDuplicatedLimits } from './project_api';

describe('project_api service', () => {
   it('_cleanDuplicatedLimits should works', () => {
      const limits: IAutomationLimits = {
         x: [new AutomationLimit(1, '1d'), new AutomationLimit(2, '1d')],
         y: [new AutomationLimit(1, '1d'), new AutomationLimit(1, '1d')],
      };

      const after = _cleanDuplicatedLimits(limits);
      expect(after.x).toHaveLength(2);
      expect(after.y).toHaveLength(1);
   });
});
