import { storiesOf } from '@storybook/react';
import { autobind, json, Loader, toasts } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { Subject } from 'rxjs';
import { finalize, takeUntil } from 'rxjs/operators';

import { IStaffPerson } from '../../models';
import { toastsSupportDecorator } from '../../stories';

import { staffApi } from './staff_api';

interface IState {
   isLoading: boolean;
   persons?: IStaffPerson[];
}

class StaffApiStories extends React.PureComponent<{}, IState> {
   public static defaultProps = {};

   public static propTypes = {};

   public state: IState = {
      isLoading: false,
   };

   private _dismounted = new Subject();

   public componentWillUnmount(): void {
      this._dismounted.next();
      this._dismounted.complete();
   }

   public render() {
      return (
         <>
            <button type={'button'} onClick={this._getPersons}>
               get khoden@yandex-team.ru, mertas@yandex-team.ru
            </button>
            <button type={'button'} onClick={this._resetState}>
               resetState
            </button>

            <Loader visible={this.state.isLoading} inline={true} />

            <pre>{json(this.state.persons)}</pre>
         </>
      );
   }

   @autobind
   private _getPersons() {
      this.setState({ isLoading: true }, () => {
         staffApi
            .getRichPersonsByEmails(['khoden@yandex-team.ru', 'mertas@yandex-team.ru'])
            .pipe(
               finalize(() => this.setState({ isLoading: false })),
               takeUntil(this._dismounted),
            )
            .subscribe(persons => this.setState({ persons }), toasts.handleApiError('Loading staff people'));
      });
   }

   @autobind
   private _resetState() {
      this.setState({
         isLoading: false,
         persons: undefined,
      });
   }
}

storiesOf('services|Staff API service', module)
   .addDecorator(toastsSupportDecorator)
   .add('regular', () => <StaffApiStories />);
