import { EMAIL_HOST, HttpMethod } from '@yandex-infracloud-ui/libs';
import { Observable } from 'rxjs';
import { map } from 'rxjs/operators';

import { IStaffApiRequestParams, IStaffApiResponse, IStaffPerson, IStaffPersonResponse } from '../../models';
import { config } from '../config';

import { WalleBaseApi } from './base_api';

class StaffApi extends WalleBaseApi {
   /**
    * https://staff-api.yandex-team.ru/v3/persons?_doc=1
    */
   public getRichPersonsByEmails(emails: string[]): Observable<IStaffPerson[]> {
      function normalizePerson(person: IStaffPersonResponse): IStaffPerson {
         return {
            email: person.emails.map(e => e.address).filter(e => e.endsWith(EMAIL_HOST))[0],
            login: person.login,
            name: `${person.name.first.en} ${person.name.last.en}`,
         } as IStaffPerson;
      }

      return this.request<IStaffApiRequestParams, void, IStaffApiResponse<IStaffPersonResponse>>(
         HttpMethod.GET,
         'persons',
         {
            _fields: 'login,emails.address,name.first.en,name.last.en',
            'emails.address': emails.join(','),
         },
      ).pipe(map(resp => resp.result.map(normalizePerson)));
   }
}

export const staffApi = new StaffApi(config.staffApi);
