import { HttpMethod } from '@yandex-infracloud-ui/libs';
import { config } from '../config';
import { WalleBaseApi } from './base_api';

export interface ITicketsListRequest {
   'input': string;
}

export interface ITicket {
   id: string;
   display: string;
   key: string;
   self: string;
}

class TicketApi extends WalleBaseApi {
   public getTickets(input: string) {
      const params: Partial<ITicketsListRequest> = {
         input,
      };

      return this.request<Partial<ITicketsListRequest>, void, ITicket[]>(HttpMethod.GET, 'issues/_suggest', params);
   }
   public getQueue(input: string) {
      const params: Partial<ITicketsListRequest> = {
         input,
      };

      return this.request<Partial<ITicketsListRequest>, void, ITicket[]>(HttpMethod.GET, 'queues/_suggest', params);
   }
}

export const ticketApi = new TicketApi(`${config.startrekApi}`);
