import '@yandex-int/error-counter/dist/interfaceWithoutRum';

import '@yandex-int/error-counter/dist/implementation';
import '@yandex-int/error-counter/dist/filters';
import '@yandex-int/error-counter/dist/sendWithoutRum';
import '@yandex-int/error-counter/dist/logAjaxError';
import '@yandex-int/error-counter/dist/logError';

import { globalState } from '../models';
import { config } from './config';

class ErrorBooster {
   public init() {
      Ya.Rum.initErrors({
         project: 'wall-e-webapp',
         env: window.location.hostname === 'wall-e.yandex-team.ru' ? 'production' : 'testing',
         limits: {
            // src/implementation.js
            client: -1,
            uncaught: -1,
            script: -1,
            external: -1,
         },
         platform: 'desktop',
         version: config.version,
         unhandledRejection: true,
      });

      globalState.user.subscribe(user => {
         // pre-configuration
         Ya.Rum.updateAdditional({
            userid: user ? user.login : 'anonymous',
            username: user ? user.name : 'anonymous',
         });
      });
   }
}

export const errorBooster = new ErrorBooster();
