/**
 * Этот файл используется исключительно для запуска dev-сервера командой `npm start`.
 * На сервере ожидается, что проксированием будет заниматься nginx.
 *
 * @file
 */

// @ts-ignore
const proxy = require('http-proxy-middleware');

module.exports = function (app) {
   const abcHost = 'abc-back.yandex-team.ru';
   app.use(
      proxy('/external_api/abc', {
         headers: { Host: abcHost },
         ignorePath: false,
         pathRewrite: {
            '/external_api/abc': '/api/v4/',
         },
         secure: false,
         target: `https://${abcHost}`,
      }),
   );

   const coronerHost = 'test-coroner-7.sas.yp-c.yandex.net:8080';
   app.use(
      proxy('/external_api/coroner', {
         headers: { Host: coronerHost },
         ignorePath: false,
         pathRewrite: {
            '/external_api/coroner': '/api/',
         },
         secure: false,
         target: `http://${coronerHost}`,
      }),
   );

   const botHost = 'bot.yandex-team.ru';
   app.use(
      proxy('/external_api/bot', {
         headers: { Host: botHost },
         ignorePath: false,
         pathRewrite: {
            '/external_api/bot': '/api/',
         },
         secure: false,
         target: `https://${botHost}`,
      }),
   );
};
