import { isAfter } from 'date-fns';
import { Button, Icon } from 'lego-on-react';
import * as React from 'react';
import { useCallback } from 'react';
import { useLocalStorage } from 'react-use';

import styles from './Banner.module.css';

interface IProps {
   buttonText: string;
   endDate?: Date;
   id: string;
   text: string;
   title: string;
   url: string;
}

export const Banner = React.memo(({ buttonText, id, title, text, url, endDate }: IProps) => {
   const [visible, setVisible] = useLocalStorage(`banners_${id}`, true);

   const toggle = useCallback(() => setVisible(false), [setVisible]);

   if (!visible || (endDate ? isAfter(new Date(), endDate) : true)) {
      return null;
   }

   return (
      <section className={styles.survey} data-e2e={'Banner'}>
         <article className={styles.text}>
            <h3 className={styles.title}>{title}</h3>
            <p>{text}</p>
         </article>

         <Button
            theme={'action'}
            size={'s'}
            type={'link'}
            url={url}
            target={'_blank'}
            cls={styles.button}
            text={buttonText}
            controlAttrs={{ 'data-e2e': 'Banner:link' }}
         />
         <Button
            theme={'clear'}
            size={'m'}
            cls={styles.close}
            controlAttrs={{ 'data-e2e': 'Banner:close' }}
            title={'Close the banner forever'}
            onClick={toggle}
            icon={<Icon type={'close'} />}
         />
      </section>
   );
});

Banner.displayName = 'Banner';
