import { action } from '@storybook/addon-actions';
import { boolean } from '@storybook/addon-knobs';
import React, { useState } from 'react';

import { IStoryDefaults } from '../../stories/typings';

import { BiasedTumbler } from './BiasedTumbler';

export const Default = () => {
   const [value, setValue] = useState(true);

   return (
      <BiasedTumbler
         preferredValue={boolean('preferredValue', true)}
         value={value}
         onChange={setValue}
         disabled={boolean('disabled', false)}
         onBlur={action('onBlur')}
      />
   );
};

export const Custom = () => {
   const [value, setValue] = useState(true);

   return (
      <BiasedTumbler
         preferredValue={boolean('preferredValue', true)}
         value={value}
         onChange={setValue}
         disabled={boolean('disabled', false)}
         trueLabel={'True label'}
         falseLabel={'False label'}
         onBlur={action('onBlur')}
      />
   );
};

export default {
   title: 'shared|BiasedTumbler',
} as IStoryDefaults;
