import { classNames, IPureValueProps } from '@yandex-infracloud-ui/libs';
import { Tumbler } from 'lego-on-react';
import React, { useCallback } from 'react';

import classes from './BiasedTumbler.module.css';

interface Props extends IPureValueProps<boolean> {
   className?: string;
   disabled?: boolean;
   falseLabel?: string;
   preferredValue: boolean;
   trueLabel?: string;

   onBlur?(): void;
}

export const BiasedTumbler: React.FC<Props> = React.memo(
   ({ className, disabled = false, value, onChange, onBlur, preferredValue, trueLabel = '', falseLabel = '' }) => {
      const handleChange = useCallback(() => {
         onChange(!value);
      }, [onChange, value]);

      return (
         <Tumbler
            theme={'normal'}
            size={'s'}
            view={'default'}
            tone={'grey'}
            disabled={disabled}
            cls={classNames(classes.control, {
               [classes.preferredTrue]: preferredValue,
               [classes.preferredFalse]: !preferredValue,
            })}
            name={'healing'}
            checked={value}
            onChange={handleChange}
            onBlur={onBlur}
         >
            <Tumbler.Off id={''} side={'right'} text={value ? trueLabel : falseLabel} />
         </Tumbler>
      );
   },
);

BiasedTumbler.displayName = 'BiasedTumbler';
