import { isEqual } from '@yandex-infracloud-ui/libs-next';
import React, { SyntheticEvent, useCallback, useRef } from 'react';

interface IProps {
   as: string;

   onClick(e: SyntheticEvent): void;
}

interface IPoint {
   x: number;
   y: number;
}

export const ClickOnlyUnmovedTrap = React.memo(({ as, onClick, ...rest }: IProps & any) => {
   const latestDownCoordinates = useRef<IPoint>();

   const onMouseDown = useCallback((e: React.MouseEvent) => {
      latestDownCoordinates.current = {
         x: e.clientX,
         y: e.clientY,
      };
   }, []);

   const onMouseUp = useCallback(
      (e: React.MouseEvent) => {
         const coordinates = {
            x: e.clientX,
            y: e.clientY,
         };

         if (isEqual(coordinates, latestDownCoordinates.current)) {
            onClick(e);
         }

         latestDownCoordinates.current = undefined;
      },
      [onClick],
   );

   return React.createElement(as, {
      ...rest,
      onMouseDown,
      onMouseUp,
   });
});

ClickOnlyUnmovedTrap.displayName = 'ClickOnlyUnmovedTrap';
