import { autobind } from '@yandex-infracloud-ui/libs';
import { Menu } from 'lego-on-react';
import { array } from 'prop-types';
import * as React from 'react';
import { SyntheticEvent } from 'react';

import { IDeployConfig, Provisioner } from '../../models';

interface IProps {
   eine: string[];
   lui: string[];

   onSelect(e: SyntheticEvent | null, item: IDeployConfig): void;
}

/**
 * Список конфигов, разбитых на две группы: LUI и EINE
 *
 * Вынес в отдельный компонент большие списки для использования
 * встроенного в React кеширования на основе PureComponent,
 * во избежания многократной перерисовки без необходимости.
 */
export class DeployConfigList extends React.PureComponent<IProps> {
   public static propTypes = {
      eine: array.isRequired,
      lui: array.isRequired,
   };

   public render() {
      const luiItems = this.props.lui.map(i => (
         <Menu.Item key={i} val={`${Provisioner.LUI}:${i}`}>
            {i}
         </Menu.Item>
      ));

      const eineItems = this.props.eine.map(i => (
         <Menu.Item key={i} val={`${Provisioner.EINE}:${i}`}>
            {i}
         </Menu.Item>
      ));

      // LUI вывожу первым, т.к. dldmitry@ сказал, что на него все переходят
      return (
         <Menu theme={'normal'} size={'s'} type={'radio'} onChange={this._onSelect}>
            <Menu.Group title={'LUI'} key={Provisioner.LUI}>
               {luiItems.length > 0 ? luiItems : 'No configs'}
            </Menu.Group>
            <Menu.Group title={'EINE'} key={Provisioner.EINE}>
               {eineItems.length > 0 ? eineItems : 'No configs'}
            </Menu.Group>
         </Menu>
      );
   }

   @autobind
   private _onSelect(values: (string | number)[]): void {
      const [provisioner, config] = (values[0] as string).split(':', 2);

      this.props.onSelect(null, {
         config,
         provisioner: provisioner as Provisioner,
      });
   }
}
