import { boolean } from '@storybook/addon-knobs';
import { storiesOf } from '@storybook/react';
import { json } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { SyntheticEvent, useState } from 'react';

import { IDeployConfig, Provisioner } from '../../models';
import { outlineDecorator } from '../../stories';

import { DeployConfigSelect } from './DeployConfigSelect';

function EmptyDeployConfigSelectStory() {
   const [value, setValue] = useState(null as IDeployConfig | null);
   const onSelect = (e: SyntheticEvent, v: IDeployConfig) => setValue(v);

   return (
      <>
         <DeployConfigSelect onSelect={onSelect} disabled={boolean('disabled', false)} />

         <pre>{json(value)}</pre>
      </>
   );
}

const initialValue: IDeployConfig = {
   config: 'ubuntu',
   provisioner: Provisioner.LUI,
};

function DeployConfigSelectStory() {
   const [value, setValue] = useState(initialValue);
   const onSelect = (e: SyntheticEvent, v: IDeployConfig) => setValue(v);

   return (
      <>
         <DeployConfigSelect initialQuery={value.config} onSelect={onSelect} disabled={boolean('disabled', false)} />

         <pre>{json(value)}</pre>
      </>
   );
}

storiesOf('shared/DeployConfigSelect', module)
   .addDecorator(outlineDecorator)
   .add('Empty', () => <EmptyDeployConfigSelectStory />)
   .add('With value', () => <DeployConfigSelectStory />);
