import React, { PropsWithChildren } from 'react';
import { Link } from 'react-router-dom';
// noinspection TypeScriptPreferShortImport
import { Page } from '../Page/Page';

import classes from './ErrorScreen.module.css';

interface Props {
   buttonText?: string;
   buttonUrl?: string;
   imgAlt: string;
   imgSrc: string;
   title: string;
   useButton?: boolean;
}

const legoBtnClasses = 'button2 button2_view_classic button2_size_n button2_theme_action';

export const ErrorScreen: React.FC<PropsWithChildren<Props>> = ({
   buttonText,
   buttonUrl,
   children,
   imgAlt,
   imgSrc,
   title,
   useButton = true,
}) => {
   if (useButton && (!buttonText || !buttonUrl)) {
      throw new Error('`buttonText` and `buttonUrl` are required if useButton is true');
   }

   return (
      <Page title={title}>
         <div className={classes.wrapper}>
            <article className={classes.screen}>
               <img className={classes.icon} src={imgSrc} alt={imgAlt} />

               <div className={classes.content}>
                  <h1 className={classes.title}>{title}</h1>

                  <div className={classes.details}>{children}</div>

                  {useButton ? (
                     // Ссылка с стилями от леговской кнопки
                     <Link className={legoBtnClasses} to={buttonUrl!}>
                        <span className={'button2__text'}>{buttonText}</span>
                     </Link>
                  ) : null}
               </div>
            </article>
         </div>
      </Page>
   );
};

ErrorScreen.displayName = 'ErrorScreen';
