import { classNames } from '@yandex-infracloud-ui/libs-next';
import { Button } from '@yandex-data-ui/common';
import React from 'react';

import classes from './FadeButton.module.css';

interface Props {
   className?: string;
   icon?: JSX.Element;
   text: string;

   onClick(): void;
}

export const FadeButton: React.FC<Props> = React.memo(({ className, text, icon, onClick }) => (
   <>
      <Button key={text} view={'clear'} size={'m'} className={classNames(classes.button, className)} onClick={onClick}>
         {icon ?? null}
         {text}
      </Button>
   </>
));

FadeButton.displayName = 'FadeButton';
