import React, { PropsWithChildren } from 'react';
import styles from './Field.module.css';

export const Field = ({ title, children }: PropsWithChildren<{ title: string }>) => (
   <div className={styles.field}>
      <div className={styles.title}>{title}</div>
      <div className={styles.body}>{children}</div>
   </div>
);

Field.displayName = 'Field';
