import { storiesOf } from '@storybook/react';
import { json, toggleSetItem } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';
import { SyntheticEvent, useState } from 'react';
// noinspection TypeScriptPreferShortImport,ES6PreferShortImport
import { UserSelectMode } from '../UserSelect/UserSelect';

import { FindUserButton } from './FindUserButton';

interface IProps {
   mode: UserSelectMode;
}

function FindUserButtonStory({ mode }: IProps) {
   // hooks
   const [value, setValue] = useState(new Set<string>());

   // handlers
   const toggle = (e: SyntheticEvent | null, login: string) => setValue(v => toggleSetItem(v, login));

   // render
   return (
      <>
         <pre>{json(value)}</pre>

         <FindUserButton mode={mode} onSelect={toggle} selected={value} />
      </>
   );
}

storiesOf('shared|FindUserButton', module)
   .add('issuers', () => <FindUserButtonStory mode={UserSelectMode.Issuers} />)
   .add('owners', () => <FindUserButtonStory mode={UserSelectMode.Owners} />);
